const express = require('express');
const app = express();

// Import Routes
const productRoutes = require('./routes/singleProduct.route');
const homeRoutes = require('./routes/home.route');
const aboutUSRoutes = require('./routes/aboutUs.route');
const contactUSRoutes = require('./routes/contactUs.route');
const InfrastructureRoutes = require('./routes/infrastructure.route');
const globalPresenceeRoutes = require('./routes/globalPresence.route');
const visionmissionRoutes = require('./routes/visionMission.route');


// Set up view engine (using EJS in this example)
app.set('view engine', 'ejs');

// Use static files (CSS, JS, images, etc.)
app.use(express.static('public'));

// Use product routes
app.use('/', productRoutes);
app.use('/', homeRoutes);
app.use('/', aboutUSRoutes);
app.use('/', contactUSRoutes);
app.use('/', InfrastructureRoutes);
app.use('/', globalPresenceeRoutes);
app.use('/', visionmissionRoutes);

// Handle server errors
app.use((err, req, res, next) => {
  console.error(err.stack);
  res.status(500).send('Something went wrong!');
});

// Set up the server to listen on a specified port
const port = 3005;

app.listen(port, () => {
  console.log(`Server is running on http://localhost:${port}`);
});
